<?php
/*
 * figupload.php - Uploading script to work with FIG (www.flashimagegallery.com)
 * Copyright (C) 2005  Pehr Johansson <pehr@mcats.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Support for .zip archives
require_once("ziplib.php");

// Constants
define( "UPLOAD_PATH", "./" );
define( "IMAGE_EXT", "/\\.(png|gif|jpg|jpeg|tif|tiff)$/i" );
define( "COMPRESSED_EXT", "/\\.(zip)$/i" );
define( "PICS_SECTION", "pictures" );
define( "PICS_TAG", "image" );
define( "PICS_ATTR1", "location" );
define( "PICS_ATTR2", "desc" );
define( "MENU_SECTION", "menu" );
define( "MENU_TAG", "menu" );
define( "MENU_ATTR1", "name" );
define( "MENU_ATTR2", "folder" );
define( "VERSION", "0.1.0" );

// Translations
$system_title = "FIG Upload Page";
$error_status_0 = "INFO:";
$error_status_1 = "WARNING:";
$error_status_2 = "ERROR:";
$error_ulpath_nowrite = UPLOAD_PATH . "/%s is not writeable!";
$error_file_nowrite = "%s is not writeable!";
$form_submit_upload = "Upload";
$form_upload_title = "Image upload";
$form_upload_target = "Target:";
$form_upload_file = "File:";
$form_upload_description = "Description:";
$form_submit_target = "Create";
$form_target_title = "Create targets";
$form_target_name = "Name:";
$form_target_folder = "Folder:";
$error_nouldirs = "No directories";
$error_upload_wrongext = "System doesn't accept files with that extension";
$error_upload_missing = "Both Target and File must be filled!";
$error_upload_exists = "An image already exist in that target with that name";
$error_upload_move = "Could not move image into target";
$status_upload_ok = "Upload completed successfully";
$error_target_missing = "Name must be filled!";
$error_target_exists = "An target already exist with that name";
$error_target_mkdir = "Could not create folder '%s'";
$status_upload_default = "Choose a file you like to upload";
$status_target_default = "Enter a directory you would like to create";

// Clear local vars
$error_text = '';
$status_text = '';

// Standard functions
// type - Type of text
// 0 - info text
// 1 - warning text
// 2 - error text
function nlappend( &$outtext, $intext, $type=0, $opt_text='' ) {
	global $error_status_0, $error_status_1, $error_status_2;
	if( $outtext != '' )
		$outtext.= "<BR>";
	// If %s in intext, replace it with opt_text
	$intext = eregi_replace( "\%s", $opt_text, $intext );
	$outtext.= ${"error_status_" . $type} . " ";
	$outtext.= $intext;
}

// Get all directories where user is allowed to upload images
function getULDirs() {
	global $error_text, $error_nouldirs, $error_ulpath_nowrite;

	// If menu.xml exists, try using this first
	if( is_writeable( UPLOAD_PATH . "/menu.xml" ) ) {
		$dirs = readXML( UPLOAD_PATH . "/menu.xml", MENU_TAG, MENU_ATTR1, MENU_ATTR2 );
	}
/*** XXX: Only using menu.xml to fetch directories at this time
	if( is_writeable( UPLOAD_PATH ) ) {
		if( $dh = opendir( UPLOAD_PATH ) ) {
			while( ( $file = readdir( $dh ) ) !== false ) {
				// Ignore hidden and . .. paths
				if( $file[0] == '.' )
					continue;
				// Verify that the directory is in fact writeable
				if( !is_writeable( UPLOAD_PATH . "/" . $file ) ) {
					nlappend( $error_text, $error_ulpath_nowrite, 2, $file );
					continue;
				}
				$dirs[] = $file;
			}
			closedir( $dh );
		}
	}
*/

	// If no directories was found, return no dir error
	if( count( $dirs ) < 1 )
		return array( 0 => array( $error_nouldirs, '' ) );

	return $dirs;
}

// Get an array of xml entries and descriptions in path/pics.xml
function readXML( $xmlfile, $tagname, $attr1, $attr2 ) {
	// Make tagname, attr1 and attr2 uppercase because xml parser needs that
	$tagname = strtoupper( $tagname );
	$attr1 = strtoupper( $attr1 );
	$attr2 = strtoupper( $attr2 );

	// If no pics.xml exists, just return
	if( !file_exists( $xmlfile ) ) {
		return;
	}

	// Read all location and desc from pics.xml and return as an array
	$xml_parser = xml_parser_create();

	if( $fp = fopen( $xmlfile, "r" ) ) {
		$data = fread( $fp, filesize( $xmlfile ) );
		fclose( $fp );

		xml_parse_into_struct( $xml_parser, $data, $vals, $index );
		xml_parser_free( $xml_parser );

		// Now, put all entries with tag IMAGE into an array
		for( $loop = 0; $loop < count( $index[$tagname] ); $loop++ ) {
			// Only get those where eighter attr1 or attr2 is set
			if( $vals[$index[$tagname][$loop]]["attributes"][$attr1] != '' || $vals[$index[$tagname][$loop]]["attributes"][$attr2] != '' )
				$entries[] = Array( $vals[$index[$tagname][$loop]]["attributes"][$attr1], $vals[$index[$tagname][$loop]]["attributes"][$attr2] );
		}
	}

	return $entries;
}

// Get an array of entries and descriptions in path/pics.xml
function writeXML( $xmlfile, $entries, $section, $tagname, $attr1, $attr2 ) {
	global $error_text, $error_file_nowrite, $error_ulpath_nowrite;

	if( file_exists( $xmlfile ) ) {
		if( !is_writeable( $xmlfile ) ) {
			nlappend( $error_text, $error_file_nowrite, 2, $xmlfile );
			return;
		}
	} elseif( !is_writeable( dirname( $xmlfile ) ) ) {
		nlappend( $error_text, $error_ulpath_nowrite, 2, dirname( $xmlfile ) );
		return;
	}

	// Write all locations to xmlfile
	$data = "<$section>\n";
	for( $loop = 0; $loop < count( $entries ); $loop++ ) {
		$data.= "<$tagname $attr1=\"" . $entries[$loop][0] . "\" $attr2=\"" . $entries[$loop][1] . "\" />\n";
	}
	$data.= "</$section>\n";

	if( $fp = fopen( $xmlfile, "w" ) ) {
		$data = fwrite( $fp, $data );
		fclose( $fp );
	}
}

// thumb - create thumbnail:
function convToJPG( $infile, $outfile, $ext, $thumb=false ) {
	$thumb_w = 148;
	$thumb_h = 118;

	if( $ext == 'gif' )
		$im = imagecreatefromgif( $infile );
	if( $ext == 'jpg' || $ext == 'jpeg' )
		$im = imagecreatefromjpeg( $infile );
	if( $ext == 'png' )
		$im = imagecreatefrompng( $infile );
	if( $ext == 'tif' || $ext == 'tiff' )
		;
	if( $ext == 'xbm' )
		$im = imagecreatefromxbm( $infile );
	if( $ext == 'xpm' )
		$im = imagecreatefromxpm( $infile );
	if( $ext == 'zip' )
		$im = imagecreatefromstring( $infile );

	// Resize the image
	if( $thumb ) {
		// Set default values for centering thumbnail
		$x = 0;
		$y = 0;
		// If output directory doesn't exist, try to create it
		if( !file_exists( dirname( $outfile ) ) ) {
			if( !mkdir( dirname( $outfile ) ) ) {
				return false;
			}
		}
		$source = $im;
		$width = imagesx( $im );
		$height = imagesy( $im );
		imagealphablending( $im, false );
		$im = imagecreatetruecolor( $thumb_w, $thumb_h );
		// Create white background
		$bgColor = imagecolorallocate($im, 255,255,255);
		imagefilledrectangle($im, 0, 0, $thumb_w-1, $thumb_h-1, $bgColor);
		// Remain aspect ratio
		if($width > $height && $thumb_h < $height){
			$new_h = ceil($height / ($width / $thumb_w));
			$new_w = $thumb_w;
		} else if ($width < $height && $thumb_w < $width) {
			$new_w = ceil($width / ($height / $thumb_h));
			$new_h = $thumb_h;
		} else {
			$new_w = $width;
			$new_h = $height;
		}
		$x = ceil( ( $thumb_w / 2 ) - ( $new_w / 2 ) );
		$y = ceil( ( $thumb_h / 2 ) - ( $new_h / 2 ) );
		imagecopyresized( $im, $source, $x, $y, 0, 0, $new_w, $new_h, $width, $height );
	}

	return @imagejpeg($im, $outfile);
}

function handleImage( $in_filename, $out_filename, $ext, $description, $ulpath ) {
	global $error_text, $error_upload_move;

	$out_filename = eregi_replace( "\.[a-z]+$", ".jpg", $out_filename );
	$thumb_filename = UPLOAD_PATH . "/" . $ulpath . "/thumbs/" . $out_filename;
	// First, move the file (And convert into to jpeg)
	if( !convToJPG( $in_filename, UPLOAD_PATH . "/" . $ulpath . "/" . $out_filename, $ext, false ) ) {
		nlappend( $error_text, $error_upload_move, 2 );
	}
	// Second, create at jpeg thumbnain
	if( !convToJPG( UPLOAD_PATH . "/" . $ulpath . "/" . $out_filename, $thumb_filename, 'jpg', true ) ) {
		nlappend( $error_text, $error_upload_move, 2 );
	}

	// Third, update pics.xml with approiate data
	$cur_pics = readXML( UPLOAD_PATH . "/" . $ulpath . "/pics.xml", PICS_TAG, PICS_ATTR1, PICS_ATTR2 );
	$cur_pics[] = array( $out_filename, eregi_replace( "\"", "&quot;", $description ) );
	writeXML( UPLOAD_PATH . "/" . $ulpath . "/pics.xml", $cur_pics, PICS_SECTION, PICS_TAG, PICS_ATTR1, PICS_ATTR2 );
	// If any error occured, try to delete the uploaded file
	if( $error_text != '' ) {
		@unlink( UPLOAD_PATH . "/" . $ulpath . "/" . $out_filename );
		@unlink( UPLOAD_PATH . "/" . $ulpath . "/thumbs/" . $out_filename );
	}
}

// Handle POSTED data
if( $_POST["action"] == $form_submit_upload ) {
	// Get POSTED data
	$ulpath = eregi_replace( "\.\.", "", $_POST["ulpath"] );
	$tmp_filename = $_FILES["filename"]["tmp_name"];
	$real_filename = $_FILES["filename"]["name"];
	$description = $_POST["description"];

	// All data fields must be filled
	if( $ulpath == '' || $tmp_filename == '' || $real_filename == '' ) {
		nlappend( $error_text, $error_upload_missing, 2 );
	}

	// Verify that the POSTED ulpath is correct
	if( !is_writeable( UPLOAD_PATH . "/" . $ulpath ) && $ulpath != '' ) {
		nlappend( $error_text, $error_ulpath_nowrite, 2, $ulpath );
	}

	// If the file hasn't the right extension, return an error
	if( !preg_match( IMAGE_EXT, $real_filename ) && !preg_match( COMPRESSED_EXT, $real_filename ) && $real_filename != '' ) {
		nlappend( $error_text, $error_upload_wrongext, 2 );
	}

	// Verify that the single image doesn't already exist
	if( preg_match( IMAGE_EXT, $real_filename ) && $error_text == '' ) {
		$jpg_filename = eregi_replace( "\.[a-z]+$", ".jpg", $real_filename );
		if( file_exists( UPLOAD_PATH . "/" . $ulpath . "/" . $jpg_filename ) && $error_text == '' ) {
			nlappend( $error_text, $error_upload_exists, 2 );
		}
	}

	// If all data is corret, proceed with the handling of uploaded file
	if( is_uploaded_file( $tmp_filename ) && $error_text == '' ) {
		// Handle compressed files
		if( preg_match( COMPRESSED_EXT, $real_filename ) ) {
			$zip = new Ziplib();
			$ziparchive = $zip->zl_index_file( $tmp_filename );
			for( $loop = 0; $loop < count( $ziparchive ); $loop++ ) {
				$zip_filename = $ziparchive[$loop]["content"];
				$real_filename = basename( $ziparchive[$loop]["filename"] );
				// If not an accepted image format in zip, just continue with the next
				if( !preg_match( IMAGE_EXT, $real_filename ) )
					continue;
				$ext = 'zip';
				handleImage( $zip_filename, $real_filename, $ext, $description, $ulpath );
			}
		}

		// Handle single files
		if( preg_match( IMAGE_EXT, $real_filename ) ) {
			$ext = eregi_replace( "^.*\.([a-z]+)$", "\\1", $real_filename );
			handleImage( $tmp_filename, $real_filename, $ext, $description, $ulpath );
		}

		// Did everything go ok?
		if( $error_text == '' )
			$status_text = $status_upload_ok;
	}
}
if( $_POST["action"] == $form_submit_target ) {
	$target_name = $_POST["target_name"];
	$target_folder = $_POST["target_folder"];

	// All data fields must be filled
	if( $target_name == '' || $target_folder == '' ) {
		nlappend( $error_text, $error_target_missing, 2 );
	}

	// Verify that the gallery path is writeable
	if( !is_writeable( UPLOAD_PATH . "/" ) ) {
		nlappend( $error_text, $error_target_nowrite, 2, $ulpath );
	}

	// Verify that the target doesn't already exist
	if( file_exists( UPLOAD_PATH . "/" . $target_folder . "/" ) && $error_text == '' ) {
		nlappend( $error_text, $error_target_exists, 2 );
	}

	// Try to create the new directory if no error occured
	if( $error_text == '' ) {
		if( mkdir( UPLOAD_PATH . "/" . $target_folder ) ) {
			if( is_writeable( UPLOAD_PATH . "/menu.xml" ) ) {
				$dirs = readXML( UPLOAD_PATH . "/menu.xml", MENU_TAG, MENU_ATTR1, MENU_ATTR2 );
				$dirs[] = array( $target_name, $target_folder );
				writeXML( UPLOAD_PATH . "/menu.xml", $dirs, MENU_SECTION, MENU_TAG, MENU_ATTR1, MENU_ATTR2 );
			}
		} else {
			nlappend( $error_text, $error_target_mkdir, 2, $target_folder );
		}
	}
}

// Check for problems in system configuration
if( !is_writeable( UPLOAD_PATH ) ) {
	nlappend( $error_text, $error_ulpath_nowrite, 2 );
}


// Prepare data to be used in HTML
$uldirs = getULDirs();
$ulpath_options = '';
for( $loop = 0; $loop < count( $uldirs ); $loop++ ) {
	$ulpath_options.= "<OPTION value=\"" . $uldirs[$loop][1] . "\">" . $uldirs[$loop][0] . "</OPTION>\n";
}

// Assign status and/or error text to correct variable
if( $_POST["action"] == $form_submit_upload ) {
	$u_status_text = $status_text;
	$u_error_text = $error_text;
	$t_status_text = $status_target_default;
} elseif( $_POST["action"] == $form_submit_target ) {
	$t_status_text = $status_text;
	$t_error_text = $error_text;
	$u_status_text = $status_upload_default;
} else {
	// If no error_text or status_text been assigned, use a default text
	if( $error_text == '' && $status_text == '' ) {
		$u_status_text = $status_upload_default;
		$t_status_text = $status_target_default;
	} else {
		$u_status_text = $status_text;
		$u_error_text = $error_text;
		$t_status_text = $status_text;
		$t_error_text = $error_text;
	}
}
?>


<HTML>
<HEAD>
<TITLE><?php echo $system_title; ?></TITLE>
<link href="upload.css" rel="stylesheet" media="screen" type="text/css" />
</HEAD>
<BODY>
<div align="center">
<!-- Start FORM -->
<FORM method="POST" enctype="multipart/form-data">
<fieldset>
<legend><?php echo $form_target_title; ?></legend>
<FONT color="red"><?php echo $t_error_text; ?></FONT>
<?php echo $t_status_text; ?>
<br /><label for="target_name"><?php echo $form_target_name; ?></label>
<input type="text"  id="target_name" name="target_name"  />
<br /><label for="target_folder"><?php echo $form_target_folder; ?></label>
<input type="text"  id="target_folder" name="target_folder"  />
<br /><label for="submit">&nbsp;</label>
<input id="create" name="action" type="submit" value="<?php echo $form_submit_target; ?>" />
<br />
</fieldset>
</FORM>
<!-- End FORM -->
</div>
<br />
<div align="center">
<!-- Start FORM -->
<FORM method="POST" enctype="multipart/form-data">
<fieldset>
<legend><?php echo $form_upload_title; ?></legend>
<FONT color="red"><?php echo $u_error_text; ?></FONT>
<?php echo $u_status_text; ?>
<br /><label for="ulpath"><?php echo $form_upload_target; ?></label>
<SELECT name="ulpath">
<?php echo $ulpath_options; ?>
</SELECT>
<br /><label for="filename"><?php echo $form_upload_file; ?></label>
<input type="file"  id="filename" name="filename"  />
<br /><label for="description"><?php echo $form_upload_description; ?></label>
<textarea name="description" id="description"></textarea>
<br /><label for="submit">&nbsp;</label><br />
<input id="upload" name="action" type="submit" value="<?php echo $form_submit_upload; ?>" />
<br />
</fieldset>
</FORM>
<!-- End FORM -->
<br />
Copyright (C) 2005 Pehr Johansson - figupload.php (<?php echo VERSION; ?>)
</div>
</BODY>
</HTML>
